<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    $firstName       = htmlspecialchars(trim($_POST['firstName']));
    $lastName        = htmlspecialchars(trim($_POST['lastName']));
    $email           = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $phone           = htmlspecialchars(trim($_POST['phone']));
    $organization    = htmlspecialchars(trim($_POST['organization']));
    $serviceInterest = htmlspecialchars(trim($_POST['serviceInterest']));
    $urgency         = htmlspecialchars(trim($_POST['urgency']));
    $message         = htmlspecialchars(trim($_POST['message']));
    $newsletter      = isset($_POST['newsletter']) ? "Yes" : "No";
    $privacy         = isset($_POST['privacy']) ? true : false;

    // Validate required fields
    $errors = [];
    if (empty($firstName)) $errors[] = "First name is required.";
    if (empty($lastName)) $errors[] = "Last name is required.";
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email is required.";
    if (empty($message)) $errors[] = "Message is required.";
    if (!$privacy) $errors[] = "You must agree to the Privacy Policy.";

    if (empty($errors)) {
        // Recipient email (change to your email)
        $to = "contact@healthcarewaypoint.com";
        $subject = "New Contact Form Inquiry from $firstName $lastName";

        // Email body
        $body = "
        New Contact Inquiry Received:

        Name: $firstName $lastName
        Email: $email
        Phone: $phone
        Organization: $organization
        Service of Interest: $serviceInterest
        Urgency Level: $urgency
        Newsletter Subscription: $newsletter

        Message:
        $message
        ";

        // Headers
        $headers = "From: noreply@healthcarewaypoint.com\r\n";
        $headers .= "Reply-To: $email\r\n";

        // Send email
        if (mail($to, $subject, $body, $headers)) {
            echo "<h2>Thank you, $firstName! Your message has been sent successfully.</h2>";
        } else {
            echo "<h2>Oops! Something went wrong. Please try again later.</h2>";
        }
    } else {
        // Show errors
        echo "<h2>Form submission failed:</h2><ul>";
        foreach ($errors as $error) {
            echo "<li>$error</li>";
        }
        echo "</ul><a href='index.html'>Go Back</a>";
    }
} else {
    // Redirect if accessed directly
    header("Location: index.html");
    exit;
}
?>
