<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize form inputs
    $firstName   = htmlspecialchars(trim($_POST['firstName']));
    $lastName    = htmlspecialchars(trim($_POST['lastName']));
    $email       = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $age         = isset($_POST['age']) ? htmlspecialchars($_POST['age']) : '';
    $interests   = isset($_POST['interests']) ? htmlspecialchars($_POST['interests']) : '';
    $preferences = isset($_POST['preferences']) ? $_POST['preferences'] : [];
    $privacy     = isset($_POST['privacyConsent']) ? true : false;

    // Validate required fields
    $errors = [];
    if (empty($firstName)) $errors[] = "First name is required.";
    if (empty($lastName)) $errors[] = "Last name is required.";
    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email is required.";
    if (!$privacy) $errors[] = "You must agree to the privacy policy.";

    if (empty($errors)) {
        // Format preferences (array → comma separated string)
        $preferencesStr = !empty($preferences) ? implode(", ", $preferences) : "None";

        // Email recipient (change this to your email)
        $to = "contact@healthcarewaypoint.com";
        $subject = "New Subscription from $firstName $lastName";
        $message = "
        New subscription received:\n\n
        Name: $firstName $lastName
        Email: $email
        Age Range: $age
        Primary Interest: $interests
        Preferences: $preferencesStr
        ";

        $headers = "From: noreply@healthcarewaypoint.com\r\n";
        $headers .= "Reply-To: $email\r\n";

        if (mail($to, $subject, $message, $headers)) {
            echo "<h2>Thank you for subscribing, $firstName!</h2>";
        } else {
            echo "<h2>Oops! Something went wrong. Please try again later.</h2>";
        }
    } else {
        echo "<h2>Form submission failed:</h2>";
        echo "<ul>";
        foreach ($errors as $error) {
            echo "<li>$error</li>";
        }
        echo "</ul>";
        echo "<a href='index.html'>Go Back</a>";
    }
} else {
    header("Location: index.html");
    exit;
}
?>
